;
;***********************
;     DEMO DC MOTOR    *
;      EXPERIMENT 4    *
;***********************

         CPU  "Z80.TBL"
         HOF  "INT8"

         ORG  2000H

MOT_ON:  EQU  10100000B
MOT_OFF: EQU  00100000B
CTRL:    EQU  0B7H
P_MOT:   EQU  0B6H
DISPY:   EQU  3FE7H
SYSCAL:  EQU  10H
PRINT:   EQU  0CH
SYSFAG:  EQU  3FFDH
SCAN:    EQU  2
SCANK:   EQU  5
KEYIN:   EQU  3FFBH
K_FUNC:  EQU  10H
K_RUN:   EQU  12H
K_DEC:   EQU  11H
K_INC:   EQU  13H
BUF:     EQU  3FEFH
CLEAR:   EQU  3
UNPK:    EQU  7
DIGIT:   EQU  2
KEY:     EQU  2
;
START:   LD   A,10010011B
         OUT  (CTRL),A
         LD   A,(SYSFAG)
         SETT 4,A
         LD   (SYSFAG),A
         LD   A,50H
         LD   (SPD_ON),A
         LD   (SPD_OFF),A
;
         LD   DE,TAB_PRG
         LD   B,20H
         LD   C,6
         LD   A,PRINT
         RST  SYSCAL
;
START1:  LD   A,SCAN
         RST  SYSCAL
         CP   K_FUNC
         JP   Z,PRG
         CP   K_RUN
         JP   Z,RUN
         JR   START1
;
;
RUN:     LD   BC,(SPD_ON)
         LD   A,MOT_ON
         OUT  (P_MOT),A
RUN1:    CALL DEL_1MS
         DEC  C
         JR   NZ,RUN1
;
         LD   A,MOT_OFF
         OUT  (P_MOT),A
RUN2:    CALL DEL_1MS
         DEC  B
         JR   NZ,RUN2
;
         LD   A,4
         OUT  (DIGIT),A
         IN   A,(KEY)
         BIT  4,A
         JR   NZ,RUN
RUN3:    IN   A,(KEY)
         BIT  4,A
         JR   Z,RUN3
         JP   PRG

;
PRG:     LD   HL,(SPD_ON)
         LD   (BUF),HL
         LD   A,UNPK
         RST  SYSCAL
         LD   HL,(DISPY+2)
         LD   (SEG_ON),HL
         LD   HL,(DISPY)
         LD   (SEG_OFF),HL
         LD   A,CLEAR
         RST  SYSCAL
         LD   A,76H          ;H
         LD   (DISPY),A
         LD   A,38H          ;L
         LD   (DISPY+3),A
         LD   HL,(SEG_ON)
         LD   (DISPY+1),HL
         LD   HL,(SEG_OFF)
         LD   (DISPY+4),HL

PRG1:    LD   A,SCAN
         RST  SYSCAL
         CP   K_DEC
         JP   Z,PRG_DEC
         CP   K_INC
         JP   Z,PRG_INC
         CP   K_RUN
         JP   Z,RUN
         JR   PRG
;
PRG_DEC: LD   A,(SPD_ON)
         SUB  1
         DAA
         CP   0
         JR   Z,PRG_DE1

         LD   (SPD_ON),A
         LD   A,(SPD_OFF)
         ADD  A,1
         DAA
         LD   (SPD_OFF),A
PRG_DE1: JP   PRG
;
PRG_INC: LD   A,(SPD_ON)
         ADD  A,1
         DAA
         CP   0
         JR   Z,PRG_IN1

         LD   (SPD_ON),A
         LD   A,(SPD_OFF)
         SUB  1
         DAA
         LD   (SPD_OFF),A
PRG_IN1: JP   PRG

DEL_1MS: LD   HL,160
DEL_1:   DEC  HL
         LD   A,H
         OR   L
         JR   NZ,DEL_1
         RET
;

TAB_PRG: DFB  73H,50H,5CH,3DH,40H,37H

         ORG  3000H
SPD_ON:  DFS  1
SPD_OFF: DFS  1
SEG_ON:  DFS  2
SEG_OFF: DFS  2
         END
